#version 400 compatibility

/*
====================================================================================================

    Copyright (C) 2020 RRe36

    All Rights Reserved unless otherwise explicitly stated.


    By downloading this you have agreed to the license and terms of use.
    These can be found inside the included license-file
    or here: https://rre36.com/copyright-license

    Violating these terms may be penalized with actions according to the Digital Millennium
    Copyright Act (DMCA), the Information Society Directive and/or similar laws
    depending on your country.

====================================================================================================
*/

/*DRAWBUFFERS:036*/
layout(location = 0) out vec4 sceneColor;
layout(location = 1) out vec4 lightmapData;
layout(location = 2) out vec3 filterAux;

#include "/lib/head.glsl"
#include "/lib/util/encoders.glsl"

/*
stand in for sky pass
*/

const int noiseTextureResolution = 256;

in vec2 coord;

flat in mat3x3 lightColor;

uniform sampler2D colortex0;
uniform sampler2D colortex1;
uniform sampler2D depthtex1;

uniform sampler2D noisetex;

uniform int frameCounter;

uniform float aspectRatio;
uniform float far, near;

uniform vec2 viewSize, pixelSize;
uniform vec2 taaOffset;

uniform vec3 upvec, upvecView;
uniform vec3 lightvec, lightvecView;

uniform mat4 gbufferModelView, gbufferModelViewInverse;
uniform mat4 gbufferProjection, gbufferProjectionInverse;

/* ------ includes ------ */
#define FUTIL_LINDEPTH
#define FUTIL_D3X3
#define FUTIL_ROT2
#include "/lib/fUtil.glsl"

#include "/lib/util/transforms.glsl"

#include "/lib/frag/bluenoise.glsl"


/* ------ ambient occlusion and gi ------ */

#include "/lib/light/ao.glsl"

#define noise_2d_only
#include "/lib/frag/noise.glsl"

vec3 getStars(vec3 spos, vec3 worldDir) {
    vec3 plane  = worldDir/(worldDir.y+length(worldDir.xz)*0.66);
        if (worldDir.y < 0.0) plane  = (-worldDir)/(-worldDir.y+length(worldDir.xz)*0.66);
    vec2 uv1    = floor((plane.xz)*768)/768;
    vec2 uv2    = (plane.xz)*0.04;

    vec3 starcol = vec3(0.5, 0.68, 1.0);
        starcol  = mix(starcol, vec3(1.0, 0.7, 0.6), noise2D(uv2).x);
        starcol  = normalize(starcol)*(noise2D(uv2*1.5).x+1.0);

    float star  = 1.0;
        star   *= noise2D(uv1).x;
        star   *= noise2D(uv1+0.1).x;
        star   *= noise2D(uv1+0.26).x;

    star        = max(star-0.25, 0.0);
    star        = saturate(star*4.0);

    return star*starcol*2.0;
}

vec3 getSun(vec3 viewDir, vec3 sunDir) {
    vec3 v      = -viewDir;
    vec3 sv     = normalize(sunDir+v);
    float sun   = dot(sv, v);

    float s   = 1.0-linStep(sun * 0.5, 0.0055, 0.0059);
        //s    *= 1.0-sstep(sun, 0.004, 0.0059)*0.5;

    return s * lightColor[0] * 64.0;
}

void main() {
    sceneColor      = stex(colortex0);
    float sceneDepth = stex(depthtex1).x;

    vec3 viewPos    = screenToViewSpace(vec3(coord, sceneDepth));
    vec3 viewDir    = normalize(viewPos);
    vec3 scenePos   = viewToSceneSpace(viewPos);
    vec3 worldDir   = normalize(scenePos);

    if (!landMask(sceneDepth)) {
        sceneColor.rgb = getStars(scenePos, worldDir);

        sceneColor.rgb += getSun(viewDir, lightvecView);
    }

    lightmapData    = vec4(0.0);
    filterAux       = vec3(0.0);

    #ifdef lightmapSmoothingEnabled
    if (landMask(sceneDepth)) {
        vec4 tex1   = stex(colortex1);
        lightmapData.xyz = vec3(decode2x8(tex1.z), sceneColor.a);
        filterAux     = decodeNormal(tex1.xy) * 0.5 + 0.5;
    }
    #endif
    
    #ifdef ambientOcclusionEnabled
        vec2 ao_coord   = (coord)*2.0;

        if (clamp(ao_coord, -0.003, 1.003) == ao_coord) {
            vec2 coord  = ao_coord;
            float d     = depthMax3x3(depthtex1, ao_coord, pixelSize*sqrt(2.0));

            if (landMask(d)) {
                float sceneDepth = stex(depthtex1).x;
                vec4 tex1       = stex(colortex1);

                vec3 viewPos    = screenToViewSpace(vec3(coord, sceneDepth));

                vec3 sceneNormal = decodeNormal(tex1.xy);
                vec3 viewnormal = normalize(mat3(gbufferModelView) * sceneNormal);
                
                #ifdef directionalSSAO
                    float ao    = getDSSAO(depthtex1, sceneNormal, sceneDepth, coord, ditherBluenoise());
                #else
                    float ao    = getSSAO(depthtex1, sceneDepth, coord, ditherBluenoise());
                #endif

                lightmapData.w   = ao;
            } else {
                lightmapData.w   = 1.0;
            }
        }
    #endif

    sceneColor      = makeDrawbuffer(sceneColor);
    lightmapData    = clamp16F(lightmapData);
    filterAux       = clamp16F(filterAux);
}